<?php

/**
 * Re.ro Plugin
 *
 * @package           Re.ro
 * @author            Nicu Criste
 * @copyright         2021 CodeValley Software
 * @license           GPL-2.0-or-later
 *
 * @wordpress-plugin
 * Plugin Name:       Re.ro Rezervari Online - Rezervari direct la tine pe site
 * Plugin URI:        https://re.ro
 * Description:       Integrează platforma re.ro pe site-ul tău.
 * Version:           0.5.1
 * Author:            Nicu Criste
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 */

class ReRoPlugin
{
  private $groupName = 'reRoPlugin';
  private $settingsSlug = 're-ro-settings';
  private $reRoSection = 'rero_section';

  function __construct()
  {
    add_action('admin_menu', [$this, 'addSettings']);
    add_action('admin_init', [$this, 'settingsFields']);
    add_shortcode('rero', [$this, 'renderIframe']);
  }

  private function url($url, $spaceSlug)
  {
    return esc_attr($url) . '/iframe/' . esc_attr($spaceSlug);
  }

  function renderIframe($atts = [], $content = null, $tag = '')
  {
    // normalize attribute keys, lowercase
    $atts = array_change_key_case((array) $atts, CASE_LOWER);

    // override default attributes with user attributes
    $args = shortcode_atts(
      [
        'url' => get_option('rero_url'),
        'slug' => get_option('rero_space_slug'),
      ],
      $atts,
      $tag
    );

    return '
      <script src="https://cdnjs.cloudflare.com/ajax/libs/iframe-resizer/4.3.7/iframeResizer.min.js" integrity="sha512-JurjZFufyOjexPw9s5Eb1VRDauHh9/ZophxPxSHcdwc94xHIlzZEhS7O2HR7po0+VW5aQEiLwUsdxLfi9zcCgg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
      <iframe src="' . $this->url($args['url'], $args['slug']) . '" id="rero-iframe"></iframe>

      <style>
      #rero-iframe {
        width: 1px;
        min-width: 100%;
      }
      </style>
      <script>
        iFrameResize({ log: false }, "#rero-iframe")
      </script>
    ';
  }

  function addSettings()
  {
    add_options_page('re.ro settings', 're.ro', 'manage_options', $this->settingsSlug, [$this, 'settingsHTML']);
  }

  function settingsHTML()
  { ?>
    <div class="wrap">
      <h1>Re.ro</h1>
      <form action="options.php" method="POST">
        <?php
        settings_fields($this->groupName);
        do_settings_sections($this->settingsSlug);
        submit_button();
        ?>
      </form>
    </div>
  <?php }

  function settingsFields()
  {
    add_settings_section($this->reRoSection, null, null, $this->settingsSlug);

    add_settings_field('rero_url', 'Url', [$this, 'urlHTML'], $this->settingsSlug, $this->reRoSection);
    register_setting($this->groupName, 'rero_url', ['sanitize_callback' => 'sanitize_text_field', 'default' => 'https://re.ro']);

    add_settings_field('rero_space', 'Space Slug', [$this, 'spaceHTML'], $this->settingsSlug, $this->reRoSection);
    register_setting($this->groupName, 'rero_space_slug', ['sanitize_callback' => 'sanitize_text_field', 'default' => '']);
  }

  function urlHTML()
  { ?>
    <input type="text" name="rero_url" value="<?php echo esc_attr(get_option('rero_url')) ?>">
  <?php }

  function spaceHTML()
  { ?>
    <input type="text" name="rero_space_slug" value="<?php echo esc_attr(get_option('rero_space_slug')) ?>">
<?php }
}

$reRoPlugin = new ReRoPlugin();
